package app.firezone.synk.network.Fragments;

import android.os.Bundle;

import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Adapter.BgmiResultAdapter;
import app.firezone.synk.network.databinding.FragmentBgmiResultBinding;
import app.firezone.synk.network.model.CheckJoinedResponse;
import app.firezone.synk.network.model.Joined_Match_Model;
import app.firezone.synk.network.model.ResultModel;
import app.firezone.synk.network.model.ResultResponse;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;


public class Bgmi_Result_Fragment extends Fragment {

    ArrayList<ResultModel> mlist = new ArrayList<>();
    BgmiResultAdapter myAdapter;
    FragmentBgmiResultBinding binding;

    String gamename;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        binding = FragmentBgmiResultBinding.inflate(inflater, container, false);
        View root = binding.getRoot();

        if (getArguments() != null) {
            gamename = getArguments().getString("gamename");
        }

        setupRecyclerView();

        fetchMatchResults();

        binding.swipeRefresh.setOnRefreshListener(() -> fetchMatchResults());

        return root;
    }

    private void setupRecyclerView() {
        LinearLayoutManager layoutManager = new LinearLayoutManager(getContext());
        layoutManager.setReverseLayout(true);
        layoutManager.setStackFromEnd(true);
        binding.bgmiResultRecy.setLayoutManager(layoutManager);

        myAdapter = new BgmiResultAdapter(mlist, getContext());
        binding.bgmiResultRecy.setAdapter(myAdapter);
    }

    private void fetchMatchResults() {
        if (!binding.swipeRefresh.isRefreshing()) {
            binding.shimmerContainer.setVisibility(View.VISIBLE);
        }

        // 🔥 Show shimmer before loading
        binding.shimmerContainer.setVisibility(View.VISIBLE);
        binding.bgmiResultRecy.setVisibility(View.GONE);
        binding.tvNoData.setVisibility(View.GONE);

        mlist.clear();

        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
        Call<ResultResponse> call = myApi.fetchResultMatchData(gamename);

        call.enqueue(new Callback<ResultResponse>() {
            @Override
            public void onResponse(Call<ResultResponse> call, Response<ResultResponse> response) {
                binding.swipeRefresh.setRefreshing(false);

                if (response.isSuccessful() && response.body() != null && response.body().isSuccess()) {
                    ArrayList<ResultModel> resultMatches = new ArrayList<>();
                    for (ResultModel match : response.body().getMatches()) {
                        if ("Result".equalsIgnoreCase(match.getMatchstatus())) {
                            resultMatches.add(match);
                        }
                    }

                    if (resultMatches.isEmpty()) {
                        showNoDataView();
                    } else {
                        enrichMatchesWithJoinData(resultMatches);
                    }
                } else {
                    showNoDataView();
                }
            }

            @Override
            public void onFailure(Call<ResultResponse> call, Throwable t) {
                binding.swipeRefresh.setRefreshing(false);
                Toast.makeText(getContext(), "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
                showNoDataView();
            }
        });
    }

    private void enrichMatchesWithJoinData(ArrayList<ResultModel> matchList) {
        long userId = SharedPrefManager.getInstance(getContext()).getUserId();
        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);

        ArrayList<ResultModel> enrichedList = new ArrayList<>();
        AtomicInteger completedCount = new AtomicInteger(0);
        int totalMatches = matchList.size();

        for (ResultModel originalMatch : matchList) {
            ResultModel match = new ResultModel();
            match.copyFrom(originalMatch);

            AtomicInteger perMatchCount = new AtomicInteger(0);
            match.setMatchCode("not_joined");
            match.setTotalPlayerJoined("0");

            myApi.checkIfUserJoined(userId, match.getId()).enqueue(new Callback<CheckJoinedResponse>() {
                @Override
                public void onResponse(Call<CheckJoinedResponse> call, Response<CheckJoinedResponse> response) {
                    if (response.isSuccessful() && response.body() != null && response.body().isSuccess()) {
                        match.setMatchCode("joined");
                    }

                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }

                @Override
                public void onFailure(Call<CheckJoinedResponse> call, Throwable t) {
                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }
            });

            myApi.fetchMatchJoinedUsers(match.getId()).enqueue(new Callback<ArrayList<Joined_Match_Model>>() {
                @Override
                public void onResponse(Call<ArrayList<Joined_Match_Model>> call, Response<ArrayList<Joined_Match_Model>> response) {
                    if (response.isSuccessful() && response.body() != null) {
                        match.setTotalPlayerJoined(String.valueOf(response.body().size()));
                    }

                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }

                @Override
                public void onFailure(Call<ArrayList<Joined_Match_Model>> call, Throwable t) {
                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }
            });
        }
    }

    private void checkIfAllMatchesProcessed(ArrayList<ResultModel> enrichedList, AtomicInteger completedCount, int totalMatches) {
        if (completedCount.incrementAndGet() == totalMatches) {
            mlist.clear();
            mlist.addAll(enrichedList);

            if (myAdapter != null) {
                myAdapter.notifyDataSetChanged();
            }

            if (mlist.isEmpty()) {
                showNoDataView();
            } else {
                // ✅ Hide shimmer and show list
                binding.shimmerContainer.setVisibility(View.GONE);
                binding.bgmiResultRecy.setVisibility(View.VISIBLE);
                binding.tvNoData.setVisibility(View.GONE);
            }
        }
    }

    private void showNoDataView() {
        binding.shimmerContainer.setVisibility(View.GONE);
        binding.bgmiResultRecy.setVisibility(View.GONE);
        binding.tvNoData.setVisibility(View.VISIBLE);
    }
}

